<?php

if ( ! defined( 'ABSPATH' ) ) exit;
if ( !class_exists('legalPages') ) :
	class legalPages
	{		
		var $plugin_url;
		var $plugin_image_url;
		var $tablename;
		var $popuptable;
			
		function __construct()
		{	global $table_prefix;
		
			$this->plugin_url = trailingslashit( WP_PLUGIN_URL.'/'.dirname( plugin_basename(__FILE__) ));
			$this->plugin_image_url = trailingslashit( WP_PLUGIN_URL.'/'.dirname( plugin_basename(__FILE__) )).'images/';
			$this->tablename = $table_prefix . "legal_pages";
			$this->popuptable = $table_prefix . "lp_popups";
			//add_action('wp_print_scripts', array($this,'scripts_action'));
			add_action('admin_menu', array($this, 'admin_menu'));
			//add_action('admin_head', array($this, 'wpgattack_enqueue_editor'));		
			add_shortcode('wp-legalpage', array($this, 'shortCode'));
			add_shortcode('wp-legalpopup', array($this, 'popupshortCode'));
			add_filter('the_content', array($this,'lpShortcode'));
			add_filter('the_excerpt', array($this,'lpShortcode'));
			add_action('wp_head', array($this,'lp_css'));
			add_action('wp_enqueue_scripts', array($this,'enqueue_frontend_script'));
			add_action('wp_footer', array($this,'wp_legalpages_show_eu_cookie_message'));
			//add_action('admin_init' , array($this, 'legalpages_check_update')  );
			add_action('wp_head' , array($this, 'disable_legal_pages_comments')  );
			
	  	$general = get_option('lp_general');		
		if(isset($general['footer']) && $general['footer'] == 1) {
			add_action('wp_footer' , array($this, 'display_legal_pages_in_footer')  );
		} //Code Added by Nishtha on 23/Oct/2015 for displaying Publish Pages in Footer Functionality in Settings 
		
		if(isset($general['download-print']) && $general['download-print'] == 1) {
			add_filter('the_content', array($this, 'print_legal_pages'), 5);
		} //Code Added by Rajashri for displaying Download and print option for Pages  
		
		if(!is_admin())
			add_action('wp_print_scripts', array($this,'scripts_action'));
			
			//add_action('add_meta_boxes', array($this, 'lp_add_custom_box'));
			//add_action('save_post', array($this, 'lp_save_postdata'));

			add_action('admin_notices', array($this,'legal_pages_admin_notices'));

			add_action('wp_dashboard_setup', array($this, 'lp_dashboard_setup'));

			$general = get_option('lp_general');
			
			if(isset($general['is_adult']) && $general['is_adult'] == 1 && !isset($_COOKIE['is_user_adult'])) {
				add_action('wp_enqueue_scripts' , array($this , 'lp_is_adult_scripts'));
				add_action('wp_footer' , array($this , 'print_is_adult_popup' ));
			}
			
			
		}
		function print_legal_pages($content)
		{
			global $wpdb;
		 	$post_id=get_the_ID();
			$general = get_option('lp_general');	
			$url=(plugins_url()."/wplegalpages/image");	
		   	$postTbl = $wpdb->prefix . "posts";
			$postmetaTbl = $wpdb->prefix . "postmeta";
			$pagesresult = $wpdb->get_results("SELECT $postmetaTbl.* FROM $postmetaTbl WHERE $postmetaTbl.post_id = $post_id AND $postmetaTbl.meta_key =  'is_legal'");
		
           	if( $pagesresult ) 
			{
				wp_register_script('legalpagesprint-js', plugins_url('/js/legalpagesprint.js', __FILE__));
				wp_enqueue_script('legalpagesprint-js');
				?><style>
				.legalpagesprint {
				text-align: center;
				float: right;
				display: flex; }
				.legalpagesprint > img {
    				width: 36% !important;}
				.legalpagesprint > a {
    				margin-left: 3px;}
				</style><?php
				$content .="<div class='legalpagesprint' data-print_target='article'><img src=".$url."/print-icon.png><a href='#'> Print</a></div>";
			}
			return $content;
		}

		function disable_legal_pages_comments(){
		$post_id=get_the_ID();
		$meta=get_post_meta($post_id, 'is_legal' , true);
		
		$general = get_option('lp_general');		
		if(isset($general['disable_comments']) && $general['disable_comments'] == 1 && $meta=='yes') {
				add_filter( 'comments_open', array($this ,'legal_disbale_comments') );
			}
		}
		

		function display_legal_pages_in_footer(){  //Code Added by Nishtha on 23/Oct/2015 for displaying Publish Pages in Footer Functionality in Settings 
        
			global $wpdb;
		 
			$general = get_option('lp_general');		
		    $postTbl = $wpdb->prefix . "posts";
			$postmetaTbl = $wpdb->prefix . "postmeta";
			$pagesresult = $wpdb->get_results("SELECT $postTbl . * 
					FROM $postTbl, $postmetaTbl
					WHERE $postTbl.ID = $postmetaTbl.post_id and $postTbl.post_status='publish'
					AND $postmetaTbl.meta_key =  'is_legal'");
           if( $pagesresult ) { ?>
 
            <?php
           $nonce = wp_create_nonce( 'my-nonce' );
		   
            
	foreach( $pagesresult as $res ) {
              $legal_page_published = $res -> post_title; 
              $legal_page_published_link = $res -> guid; 

           ?>
            <div id='published-pages'><a href= <?php echo $legal_page_published_link ?> style="float:left; width:12%; color:<?php echo  '#'.$general['footer-color']?>"><?php echo $legal_page_published ?></a></div>
			<?php
                
            }
          } 
	     
		}
		
		function legalpages_check_update(){
		
			$plugin_data = get_plugin_data( LP_PLUGIN_DIR."/legal-pages.php" );
			$plugin_version = $plugin_data['Version'];
		
			if(isset($_GET['check']) && $_GET['check'] == 'update') {
		
				$UpdateFile =  file_get_contents( 'http://wplegalpages.com/legalpages_notifier.xml' );
				$xml = simplexml_load_string($UpdateFile);
				$status = (string) $xml->latest;
				$Version = $status;
				update_option('legalpages_latest_version' , $status);
			}
			if( get_option('legalpages_latest_version') > $plugin_version ){
				add_action('admin_notices', array($this, 'legalpages_update_notice' ));
			}
			else{ 
				if( get_option('legalpages_latest_version') == $plugin_version ){
					if(isset($_GET['check']) && $_GET['check'] == 'update')
						add_action('admin_notices', array($this, 'legalpages_updated' ));
				}
			}
			}
		
		function legal_pages_admin_notices() {
			if ( !get_option('legal_pages_notice_shown') && !is_plugin_active(LP_PLUGIN_DIR."/legal-pages.php") ) 
			{
				echo "<div class='updated'><p>If you have recently updated to Version 4.5 or greater , please de-activate and activate WPLegalPages once, in order to refresh your legal page templates.</p></div>";
				update_option('legal_pages_notice_shown', 'true');
			}
		}
		
		function legalpages_updated(){
			echo "<div class='updated'><p>You are running the latest version of WPLegalPages</p></div>";
		}
		
		function legalpages_update_notice() {
			$plugin_data = get_plugin_data( LP_PLUGIN_DIR."/legal-pages.php" );
			$plugin_version = $plugin_data['Version'];
			$status = get_option('legalpages_latest_version');
		
			?>
					<div class="error">
						<p><?php _e('You are running Version '.$plugin_version.' of WPLegalPages and the latest WPLegalPages Version is '.$status.'. Please login to your Members Area (http://wplegalpages.com/members/) and update.'); ?>		        		
						</p>
			    	</div>
			    	<?php 
			}
		
		function legal_disbale_comments( $open ) {
				
			$post = get_post_meta( get_the_ID(),'is_legal' );
		
			if ( $post[0] == 'yes' )
				$open = false;
				
			return $open;
		}
		
		function lp_dashboard() 
		{
			echo '<span style="line-height:18px;">WP Legal Pages plugin is the easiest method to create legal pages for your website.</span>';
		}
		
		function lp_dashboard_setup() 
		{
			wp_add_dashboard_widget( 'lp_dashboard_widget','Legal Pages', array($this, 'lp_dashboard'));
		}
		
		function install()
		{
			global $wpdb;
			
			//echo dirname(__FILE__) . '/templates/Terms.php';exit;
			$terms_forced = file_get_contents(dirname(__FILE__) . '/templates/Terms-latest.php');
			$terms = file_get_contents(dirname(__FILE__) . '/templates/Terms.php');
			$privacy = file_get_contents(dirname(__FILE__) . '/templates/privacy.php');
			$earnings = '<div style="text-align: center; font-weight: bold;">Earnings Disclaimer<br></div><br><br>EVERY EFFORT HAS BEEN MADE TO ACCURATELY REPRESENT THIS PRODUCT AND IT\'S POTENTIAL. EVEN THOUGH THIS INDUSTRY IS ONE OF THE FEW WHERE ONE CAN WRITE THEIR OWN CHECK IN TERMS OF EARNINGS, THERE IS NO GUARANTEE THAT YOU WILL EARN ANY MONEY USING THE TECHNIQUES AND IDEAS IN THESE MATERIALS. EXAMPLES IN THESE MATERIALS ARE NOT TO BE INTERPRETED AS A PROMISE OR GUARANTEE OF EARNINGS. EARNING POTENTIAL IS ENTIRELY DEPENDENT ON THE PERSON USING OUR PRODUCT, IDEAS AND TECHNIQUES. WE DO NOT PURPORT THIS AS A "GET RICH SCHEME."<br> <br> ANY CLAIMS MADE OF ACTUAL EARNINGS OR EXAMPLES OF ACTUAL RESULTS CAN BE VERIFIED UPON REQUEST. YOUR LEVEL OF SUCCESS IN ATTAINING THE RESULTS CLAIMED IN OUR MATERIALS DEPENDS ON THE TIME YOU DEVOTE TO THE PROGRAM, IDEAS AND TECHNIQUES MENTIONED, YOUR FINANCES, KNOWLEDGE AND VARIOUS SKILLS. SINCE THESE FACTORS DIFFER ACCORDING TO INDIVIDUALS, WE CANNOT GUARANTEE YOUR SUCCESS OR INCOME LEVEL. NOR ARE WE RESPONSIBLE FOR ANY OF YOUR ACTIONS.<br> <br> MATERIALS IN OUR PRODUCT AND OUR WEBSITE MAY CONTAIN INFORMATION THAT INCLUDES OR IS BASED UPON FORWARD-LOOKING STATEMENTS WITHIN THE MEANING OF THE SECURITIES LITIGATION REFORM ACT OF 1995. FORWARD-LOOKING STATEMENTS GIVE OUR EXPECTATIONS OR FORECASTS OF FUTURE EVENTS. YOU CAN IDENTIFY THESE STATEMENTS BY THE FACT THAT THEY DO NOT RELATE STRICTLY TO HISTORICAL OR CURRENT FACTS. THEY USE WORDS SUCH AS "ANTICIPATE," "ESTIMATE," "EXPECT," "PROJECT," "INTEND," "PLAN," "BELIEVE," AND OTHER WORDS AND TERMS OF SIMILAR MEANING IN CONNECTION WITH A DESCRIPTION OF POTENTIAL EARNINGS OR FINANCIAL PERFORMANCE.<br> <br> ANY AND ALL FORWARD LOOKING STATEMENTS HERE OR ON ANY OF OUR SALES MATERIAL ARE INTENDED TO EXPRESS OUR OPINION OF EARNINGS POTENTIAL. MANY FACTORS WILL BE IMPORTANT IN DETERMINING YOUR ACTUAL RESULTS AND NO GUARANTEES ARE MADE THAT YOU WILL ACHIEVE RESULTS SIMILAR TO OURS OR ANYBODY ELSES, IN FACT NO GUARANTEES ARE MADE THAT YOU WILL ACHIEVE ANY RESULTS FROM OUR IDEAS AND TECHNIQUES IN OUR MATERIAL.<br>  <br> The author and publisher disclaim any warranties (express or implied), merchantability, or fitness for any particular purpose. The author and publisher shall in no event be held liable to any party for any direct, indirect, punitive, special, incidental or other consequential damages arising directly or indirectly from any use of this material, which is provided "as is", and without warranties.<br> <br> As always, the advice of a competent legal, tax, accounting or other  professional should be sought.<br> <br> [Domain] does not warrant the performance, effectiveness or applicability of any sites listed or linked to on [Domain]<br> <br> All links are for information purposes only and are not warranted for content, accuracy or any other implied or explicit purpose.<br> <br>';
		
			$disclaimer = file_get_contents(dirname(__FILE__) . '/templates/disclaimer.php');
			$testimonials = file_get_contents(dirname(__FILE__) . '/templates/testimonial-disclosure.php');
			$linking = file_get_contents(dirname(__FILE__) . '/templates/linking-policy.php');
			$refund = file_get_contents(dirname(__FILE__) . '/templates/refund-policy.php');
			$affiliate = file_get_contents(dirname(__FILE__) . '/templates/affiliate-agreement.php');
			$disclosure = file_get_contents(dirname(__FILE__) . '/templates/affiliate-disclosure.php');
			$antispam = file_get_contents(dirname(__FILE__) . '/templates/antispam.php');
			$ftc = file_get_contents(dirname(__FILE__) . '/templates/ftcstatement.php');
			$medical = file_get_contents(dirname(__FILE__) . '/templates/medical-disclaimer.php');
			$amazon = file_get_contents(dirname(__FILE__) . '/templates/amazon-affiliate.php');
			$dart = file_get_contents(dirname(__FILE__) . '/templates/double-dart-cookie.php');
			$external = file_get_contents(dirname(__FILE__) . '/templates/external-links.php');
			$fbpolicy = file_get_contents(dirname(__FILE__) . '/templates/fbpolicy.php');
			$about_us = file_get_contents(dirname(__FILE__) . '/templates/about-us.php');
			
			

			add_option('lp_excludePage','true');
			add_option('lp_general', '');
			add_option('lp_accept_terms','0');
			add_option('lp_eu_cookie_title','A note to our visitors');
			$message_body="This website has updated its privacy policy in compliance with EU Cookie legislation. Please read this to review the updates about which cookies we use and what information we collect on our site. By continuing to use this site, you are agreeing to our updated privacy policy.";
			add_option('lp_eu_cookie_message',htmlentities($message_body));
			add_option('lp_eu_cookie_enable','OFF');
			add_option('lp_eu_box_color','#DCDCDC');
			add_option('lp_eu_button_color','#24890d');
			add_option('lp_eu_button_text_color','#333333');
			add_option('lp_eu_text_color','#333333');
			
			$sql = "CREATE TABLE IF NOT EXISTS `$this->tablename` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `title` text NOT NULL,
					  `content` longtext NOT NULL,
					  `notes` text NOT NULL,
					  `contentfor` varchar(200) NOT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM;";
			$sqlpopup = "CREATE TABLE IF NOT EXISTS `$this->popuptable` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `popupName` text NOT NULL,
					  `content` longtext NOT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM;";
			$wpdb->query($sql);
			$wpdb->query($sqlpopup);
			$wpdb->insert($this->tablename,array('title'=>'Terms(forced agreement)','content'=>$terms,'contentfor'=>'1a2b3c4d5e6f7g8h9i'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Terms of Use','content'=>$terms_forced,'contentfor'=>'1a2b3c4d5e6f7g8h9i'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Privacy Policy','content'=>$privacy,'contentfor'=>'1a2b3c4d5e6f7g8h9i'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Earnings Disclaimer','content'=>$earnings,'contentfor'=>'4d5e6f7g8h'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Disclaimer','content'=>$disclaimer,'contentfor'=>'1a2b3c4d5e6f7g8h9i'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Testimonials Disclosure','content'=>$testimonials,'contentfor'=>'1a2b3c4d5e6f7g8h9i'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Linking Policy','content'=>$linking,'contentfor'=>'1a2b3c9i'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Refund-Policy','content'=>$refund,'contentfor'=>'2b3c9i'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Affiliate Agreement','content'=>$affiliate,'contentfor'=>'3c'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Antispam','content'=>$antispam,'contentfor'=>'3c'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'FTC Statement','content'=>$ftc,'contentfor'=>'4d5e7g'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Medical Disclaimer','content'=>$medical,'contentfor'=>'6f'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Amazon Affiliate','content'=>$amazon,'contentfor'=>'7g'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Double Dart Cookie','content'=>$dart,'contentfor'=>'8h'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'External Links Policy','content'=>$external,'contentfor'=>'4d5e6f7g8h9i'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'Affiliate Disclosure','content'=>$disclosure,'contentfor'=>'4d'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'FB Policy','content'=>$fbpolicy,'contentfor'=>'4d'),array('%s','%s','%s'));
			$wpdb->insert($this->tablename,array('title'=>'About Us','content'=>$about_us,'contentfor'=>'1a2b3c4d5e6f7g8h9i'),array('%s','%s','%s'));
			
		}
		
		function admin_menu()
		{
			add_menu_page('Legal Pages', 'Legal Pages', 'manage_options', 'legal-pages', array($this, 'adminSetting'));
			$terms = get_option('lp_accept_terms');
			if($terms == 1){
				add_submenu_page('legal-pages', 'Settings', 'Settings', 'manage_options', 'legal-pages', array($this, 'adminSetting'));
				add_submenu_page('legal-pages', 'Legal Pages', 'Legal Pages', 'manage_options', 'showpages', array($this, 'showpages'));
				add_submenu_page('legal-pages', 'Create Page', 'Create Page', 'manage_options', 'lp-create', array($this, 'createPage'));			
				add_submenu_page('legal-pages', 'Create/Edit Templates', 'Create/Edit Templates', 'manage_options', 'lp-templates', array($this, 'createTemplates'));
				add_submenu_page('legal-pages', 'Create Popups', 'Create Popups', 'manage_options', 'lp-popups', array($this, 'createPopups'));
				add_submenu_page('legal-pages', 'EU Cookies', 'EU Cookies', 'manage_options', 'lp-eu-cookies', array($this, 'update_eu_cookies'));
			}
			
		}
		
		function createPage()
		{
			include_once('createPage.php');
		}
		
	    function showpages()
		{
			include_once('showpages.php');
		}
		function createPage1()
		{
			include_once('createPage1.php');
		}
		function createTemplates()
		{
			include_once('createTemplates.php');
		}
		function createPopups()
		{
			include_once('createPopups.php');
		}
		function adminSetting()
		{
			include_once("adminSetting.php");
		}
		
		function adminTerms()
		{
			include_once("adminTerms.php");
		}
		
		function adminPrivacy()
		{
			include_once("adminPrivacy.php");
		}
		
		function adminDisclaimer()
		{
			include_once("adminDisclaimer.php");
		}
				
		function update_eu_cookies()
		{
			include_once("updateEUCookies.php");
		}
				
		function deactivate()
		{
			global $wpdb;
			
			delete_option('lp_excludePage');
			delete_option('lp_accept_terms');
			delete_option('lp_eu_cookie_title');
			delete_option('lp_eu_cookie_message');
			delete_option('lp_eu_cookie_enable');
			delete_option('lp_eu_box_color');
			delete_option('lp_eu_button_color');
			delete_option('lp_eu_button_text_color');
			delete_option('lp_eu_text_color');
			remove_meta_box( 'lp_dashboard_widget', 'dashboard', 'side' );
			remove_meta_box( 'lp_dashboard_widget', 'dashboard', 'normal' );
			$wpdb->query("Drop table $this->tablename");
			$wpdb->query("Drop table $this->popuptable");
		}
		
		function lpShortcode($content)
		{
			//$lp_find = array("[Domain]","[Business Name]","[Phone]","[Street]","[City, State, Zip code]","[Country]","[Email]","[Address]","[Niche]","[facebook-url]","[google-url]","[twitter-url]","[linkedin-url]");
			$lp_find = array("[Domain]","[Business Name]","[Phone]","[Street]","[City, State, Zip code]","[Country]","[Email]","[Address]","[Niche]");
			$lp_general = get_option('lp_general');
			$cont = str_replace($lp_find,$lp_general,stripslashes($content));

			/*	
			*	Get social icons shortcode content and maps Latitude Longitude from page-content
			*	Added by Kaustubh
			*/

			$latitude = '';
			$longitude = '';
			$facebook = '';
			$google = '';
			$twitter = '';
			$linkedin = '';

			$pos = strpos($cont, "[latitude]");
			if($pos !== false){
				
				require_once('map.php');
				$output=add_map();

				if(!empty($output->results)){
						$latitude = $output->results[0]->geometry->location->lat;
						$longitude = $output->results[0]->geometry->location->lng;
				}
				$lp_map_find=array("[latitude]","[longitude]");
				$map_dimension=array("latitude"=>$latitude,"longitude"=>$longitude);
				$cont = str_replace($lp_map_find,$map_dimension,stripslashes($cont));
			}
			
			$url=(plugins_url()."/wplegalpages/image");

			$facebook_url = isset( $lp_general['facebook-url'] ) ? $lp_general['facebook-url'] : '';	

			if($facebook_url){

				$facebook=array("facebook"=>'<a style="width: 30px; height: 30px; display:inline-block" href="'. $facebook_url.'"><img src="'.$url.'/facebook.png"/></a>');
			}
			$lp_find_facebook=array("[facebook]");
			$cont = str_replace($lp_find_facebook,$facebook,stripslashes($cont));

			$google_url = isset( $lp_general['google-url'] ) ? $lp_general['google-url'] : '';

			if($google_url){

				$google=array("google"=> '<a style="width: 30px; height: 30px; display:inline-block" href="'. $google_url.'"><img src="'.$url.'/google.png"/></a>');
			}
			$lp_find_google=array("[google]");
			$cont = str_replace($lp_find_google,$google,stripslashes($cont));
		
			$twitter_url = isset( $lp_general['twitter-url'] ) ? $lp_general['twitter-url'] : '';
			if($twitter_url){

				$twitter=array("twitter"=>'<a style="width: 30px; height: 30px; display:inline-block" href="'.$twitter_url.'"><img src="'.$url.'/twitter.png"/></a>');
			}
			$lp_find_twitter=array("[twitter]");
			$cont = str_replace($lp_find_twitter,$twitter,stripslashes($cont));

			$linkedin_url = isset( $lp_general['linkedin-url'] ) ? $lp_general['linkedin-url'] : '';
			if($linkedin_url){
				$linkedin=array("linkedin"=>'<a style="width: 30px; height: 30px; display:inline-block" href="'. $linkedin_url.'"><img src="'.$url.'/linkedin.png"/></a>');
			}
			$lp_find_linkedin=array("[linkedin]");
			$cont = str_replace($lp_find_linkedin,$linkedin,stripslashes($cont));

			return $cont;
		}
		function scripts_action()
		{
				wp_enqueue_script('jquery');
				wp_enqueue_style('media-query',$this->plugin_url. 'css/media.css');
		}
		
		function lp_enqueue_editor() 
		{
			wp_enqueue_script('common');
			wp_enqueue_script('jquery-affect');
			wp_admin_css('thickbox');
			wp_print_scripts('post');
			wp_print_scripts('media-upload');
			wp_print_scripts('jquery');
			wp_print_scripts('jquery-ui-core');
			wp_print_scripts('jquery-ui-tabs');
			
			wp_print_scripts('editor');
			
		
			/* Include the link dialog functions */
			//include ABSPATH . 'wp-admin/includes/internal-linking.php';
			wp_print_scripts('wplink');
			wp_print_styles('wplink');
			add_thickbox();
			wp_admin_css();
			wp_enqueue_script('utils');
			do_action("admin_print_styles-post-php");
			do_action('admin_print_styles');
			//remove_all_filters('mce_external_plugins');
		}
		
		function shortCode($atts)
		{global $wpdb;
			global $post;
			global $wp_query;			
			
			extract( shortcode_atts( array(
					'tid' => 1
					), $atts ) );		
			
				$res = $wpdb->get_row($wpdb->prepare('SELECT * from '.$this->tablename.' where id= %d',$tid));
				$content = $this->lpShortcode($res->content);
				//$content = "select * from $this->tablename where id='$tid'";
			
			
			if(is_single() || is_page())
			{
				return $content;
			}
		}
		
		function popupshortCode($atts)
		{
			global $wpdb;
			global $post;
			global $wp_query;			
			
			extract( shortcode_atts( array(
					'pid' => 1
					), $atts ) );		
			
				$res = $wpdb->get_row($wpdb->prepare('SELECT * from '.$this->popuptable.' where id= %d',$pid));
			
			//if($wpgattack_addscript == 'true')
			//{
				
				echo "<script type='text/javascript' src='".$this->plugin_url."fancybox/jquery.fancybox-1.3.1.pack.js?ver=1.3.1'></script>";
				echo '<link rel="stylesheet" href="'.$this->plugin_url.'fancybox/jquery.fancybox-1.3.1.css" type="text/css" media="screen" />';
				?>
                <script type="text/javascript">
				jQuery(document).ready(function(){
								
				 jQuery('a#wpepoll_link').fancybox(
				{
					'autoDimensions': true,
					'padding' : 25,
					'margin'  : 0,
					'width': 'auto',
					'height': 'auto',
					'hideOnOverlayClick': false,
					'showCloseButton' : false,
					'enableEscapeButton' : false
				});
				 jQuery( '#wpepollid' ).children().css( 'width', '100%' ); 
				 /*jQuery( '#wpepollid' ).children().children().css( 'width', '100%' );*/
				 jQuery( '#fancybox-inner' ).css( 'position', 'static' );
				jQuery('a#wpepoll_link').trigger('click');
			});
			jQuery('a#wpepoll_link').trigger('click');
			</script>
		<?php 
		$terms = apply_filters('the_content',$res->content);
		$terms = $this->lpShortcode($terms);
		
		$content = '<a id="wpepoll_link" href="#wpepollid" style="display: none;position:relative;">WP EPoll</a>			
				<div style="display: none;">
					<div id="wpepollid" style="max-width:1000px;width:100%; padding: 25px;">
						'.$terms.'
						<p>&nbsp;</p>
						<p style="padding: 20px;"><input type="checkbox" name="lp_accept" id="lp_accept" value="1" onclick="jQuery(\'.accept\').toggle();" /> I agree to the terms and conditions.
						<input type="submit" name="lp_submit" id="lp_submit" value="Accept" onclick="jQuery.fancybox.close();" class="accept" style="padding: 15px; display:none;"/></p>
						<br/>
						<br/>
					</div>
                </div>';
			 //}
			if(is_single() || is_page())
			{
				return $content;
			}
		}
		
		function footerPages(){
			$general = get_option('lp_general');
					
			remove_filter('get_pages','lp_exclude_pages');
			echo "<ul class='legalfooter'>";
			wp_list_pages("title_li=&include=$general[pagefooter]");
			echo "</ul>";
			add_filter('get_pages','lp_exclude_pages');
		}
		
		function lp_css(){
			?>
            <style type="text/css">
				ul.legalfooter li{
					list-style:none;
					float:left;
					padding-right:20px;
				}
				.accept{
					display:none;
					border: 1px solid #000;
					background:#000;
					color:#fff;
					border-radius:3px;
					-moz-border-radius:3px;
					-webkit-border-radius:3px;
					padding:5px;
				} 
			</style>
            <?php 
		}
		
		function enqueue_frontend_script(){
			wp_enqueue_script( 'jquery-cookie',  $this->plugin_url. 'js/jquery.cookie.js', array('jquery') );
		}
		
		function wp_legalpages_show_eu_cookie_message(){
			$lp_eu_get_visibility=get_option('lp_eu_cookie_enable');
			$lp_eu_title=get_option('lp_eu_cookie_title');
			$lp_eu_message=get_option('lp_eu_cookie_message');
			$lp_eu_box_color=get_option('lp_eu_box_color');
			$lp_eu_button_color=get_option('lp_eu_button_color');
			$lp_eu_button_text_color=get_option('lp_eu_button_text_color');
			$lp_eu_text_color=get_option('lp_eu_text_color');
			
			if($lp_eu_get_visibility=='ON'){
				$lp_eu_html='<div id="lp_eu_container">';
				$lp_eu_html.='<h5 id="lp_eu_title">'.$lp_eu_title.'</h5>';
				$lp_eu_html.='<p id="lp_eu_body">'.stripslashes(html_entity_decode($lp_eu_message)).'</p>';
				$lp_eu_html.='<p id="lp_eu_btnContainer"><button id="lp_eu_btn_agree">I AGREE</button></p>';
				$lp_eu_html.='<p id="lp_eu_notice_info">This notice should appear only the first time you visit the site.</p>';
				$lp_eu_html.='</div>';
			
                echo '<style>
					#lp_eu_container{
						display: none;
						padding: 10px;
						width: 100%;
						z-index: 9999;
						position: fixed;
						bottom: 0px;
					}
					#lp_eu_title{
						margin: inherit;
					}
					#lp_eu_notice_info{
						font-size: 9px;
					}
					#lp_eu_body,#lp_eu_btnContainer,#lp_eu_notice_info{
						margin: 0 0 10px;
					}
				</style>';
		
                ?>
                <script type="text/javascript">
				jQuery(document).ready(function(){
					if (jQuery.cookie('lp_eu_agree') == null) {
						jQuery.cookie('lp_eu_agree', 'NO', { expires: 7, path: '/' });
						lp_eu_show_cookie_bar();
					}
					else if (jQuery.cookie('lp_eu_agree') == 'NO') {
						lp_eu_show_cookie_bar();
					}
					jQuery('#lp_eu_btn_agree').click(function (){
						jQuery.cookie('lp_eu_agree', 'YES', { expires: 7, path: '/' });
						jQuery('#lp_eu_container').hide(500);
					});				
				});
				function lp_eu_show_cookie_bar(){
					jQuery('body').prepend('<?php echo $lp_eu_html; ?>');
					jQuery('#lp_eu_container').css('background-color','<?php echo $lp_eu_box_color; ?>');
					jQuery('#lp_eu_btn_agree').css('background-color','<?php echo $lp_eu_button_color; ?>');
					jQuery('#lp_eu_container').css('color','<?php echo $lp_eu_text_color; ?>');
					jQuery('#lp_eu_btn_agree').css('color','<?php echo $lp_eu_button_text_color; ?>');
					jQuery('#lp_eu_container').show(500);
				}
				</script>
			<?php 
			}
		}
		
		function print_is_adult_popup(){
			$general = get_option('lp_general');
			?>
									<a id="inline" style="display:none" href="#data">This shows content of element who has id="data"</a>
									
									<div style="display:none"><div id="data">
										<p>This website contains content suitable for adults only . Please proceed only if you are above your country's legal age limit.</p>
				<a href="#" id="enter_site">Yes,I am above my country's legal age limit (Enter)</a>    <a href="<?php echo $general['leave-url']; ?>" id="leave_site">Leave</a>
									</div></div>
									<script type="text/javascript">
				jQuery(document).ready(function($) {
					$('#enter_site').click(function(){
						$.cookie("is_user_adult", 1);
						$.fancybox.close();
					});	
					/* This is basic - uses default settings */
					
					$("a#inline").fancybox({'showCloseButton' : false,'closeBtn' : false}).trigger('click');
					/* Using custom settings */
					$("a#inline").fancybox({
						'hideOnContentClick': true
					});
					/* Apply fancybox to multiple items */
				});
				</script>
									<?php 	
								}
				
				function lp_is_adult_scripts(){
					wp_enqueue_script('jquery');
					wp_enqueue_style( 'lp_jquery.fancybox-css', $this->plugin_url.'/js/fancybox/jquery.fancybox.css');
					wp_enqueue_script('lp_jquery.fancybox-js',$this->plugin_url.'/js/fancybox/jquery.fancybox.js');
				}
				
	}
else :
	exit ("Class legalPages already declared!");
endif;

/************* widget code - start ***********/
class WP_Legal_Pages extends WP_Widget {


	public function __construct() {
		$widget_ops = array(
				'classname' => 'wp_legal_pages',
				'description' => 'WP Legal Pages Widget is awesome',
		);
		parent::__construct( 'wp_legal_pages', 'WP Legal Pages', $widget_ops );
		
	}
	
	
	public function widget( $args, $instance ) {
		global $wpdb;
		$resultcontent = $wpdb->get_results("select title,content from wp_legal_pages where id=".$instance['lpSelect']);

		echo $args['before_widget'];
		foreach($resultcontent as $ras){
			_e('<h5>'.$ras->title.'</h5><hr>');
			_e($ras->content);
		}
		echo $args['after_widget'];
	
	}
	
	
	public function form( $instance ) {
		global $wpdb;
		
		_e('<h3>Choose Template</h3><br/>');
	?>
    	

    	<div>
			<select id="lpSelect" name="lpSelect">
		        <?php 
				$result = $wpdb->get_results("select id,title from wp_legal_pages");
				

				foreach($result as $ras){

					$lpvalue = isset( $instance['lpSelect'] ) ? $instance['lpSelect'] : '';

					if($lpvalue==$ras->id){		
				?><option value="<?php echo $ras->id;?>" selected><?php echo $ras->title;?></option>
		        <?php }else{ ?>			
		           <option value="<?php echo $ras->id;?>"><?php echo $ras->title;?></option>
		        <?php }}?>
        	</select>
        </div><br><br>
     <?php 
		return $instance;
	}
	
	public function update( $new_instance, $old_instance ) {
		$new_instance['lpSelect']=$_POST['lpSelect'];
		return $new_instance;
		
	}
	
}

add_action( 'widgets_init', function(){
	register_widget( 'WP_Legal_Pages' );
});


?>
